<?php
/**
*  Conexiaweb.es
*  @author conexiaweb.es <info@conexiaweb.es>
*  @copyright  2020  Conexiaweb.es
*  @license    http://conexiaweb.es
*  Great!!!    http://transfertomalaga.es | http://transfertocordoba.es | http://transfertomarbella.com/ | http://transfervalladolid.es/ | http://transfertosevilla.es/ | http://transfertogranada.es/ | http://transfertorremolinos.es/ | http://transferfuengirola.es/ | http://transferbenalmadena.es/ | http://transfertomarbella.com/ | http://transfertonerja.es/ | http://transfertomijas.es/ | http://transfertorredelmar.es/ | http://laborser.es | http://multiserviciosencordoba.es
*/

class ConexiaExport extends Module
{
	public function __construct()
	{
		$this->name = 'conexiaexport';
		$this->tab = 'administration';
		$this->version = '1.0.0';
		$this->displayName = 'Exportación de productos';
		$this->author = 'Conexiaweb';
		$this->description = 'Un módulo para la exportación de productos de tu tienda Prestashop';

		parent::__construct();
	}

	public function install()
	{
		$this->installController('AdminConexiaExport', 'Conexia Exportación');
		return parent::install();

	}

	private function installController($controllerName, $name) {

        
        $tab_id = Tab::getIdFromClassName('AdminAdvancedParameters') ? Tab::getIdFromClassName('AdminAdvancedParameters') : Tab::getIdFromClassName('AdminTools');
    

        $tab = new Tab();
        $tab->class_name = $controllerName;
        $tab->id_parent = $tab_id;
        $tab->module = $this->name;
        $languages = Language::getLanguages(false);
        foreach($languages as $lang){
            $tab->name[$lang['id_lang']] = $name;
        }
    	$tab->save();
	}

	public function uninstall()
	{
		$this->uninstallController('AdminConexiaExport');
		return parent::uninstall();
	}

	public function uninstallController($controllerName) {

	    $tab_id = (int) Tab::getIdFromClassName($controllerName);
	    $tab = new Tab($tab_id);
	    
        if (Validate::isLoadedObject($tab)) {
            $tab->delete();
        }

	}

}
