<?php

/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

namespace PrestaShop\Module\Ps_metrics\Middleware;

use PrestaShop\Module\Ps_metrics\Helper\JsonHelper;

class CheckResponseMiddleware extends Middleware
{
    /**
     * @var JsonHelper
     */
    private $jsonHelper;

    /**
     * CheckResponseAnalyticsMiddleware constructor.
     *
     * @param JsonHelper $jsonHelper
     *
     * @return void
     */
    public function __construct(JsonHelper $jsonHelper)
    {
        $this->jsonHelper = $jsonHelper;
    }

    /**
     * @param mixed $response
     *
     * @return array
     */
    public function execute($response): array
    {
        $responseFormatted = [
            'code' => $response->getStatusCode(),
            'body' => [],
            'error' => '',
        ];

        if (
            200 != $response->getStatusCode() &&
            201 != $response->getStatusCode()
        ) {
            $responseFormatted['error'] = $response->getReasonPhrase();
        }
        if (!empty($response->getBody())) {
            $content = $response->getBody()->getContents();

            if (!empty($content) && $this->jsonHelper->isJson($content)) {
                $responseFormatted['body'] = $this->jsonHelper->jsonDecode($content, true);
            } else {
                $responseFormatted['body'] = $content;
            }
        }

        return parent::execute($responseFormatted);
    }
}
